<style>
    .wpmet-ann {
        display: flex;
        flex-wrap: wrap;
        width: 100%;
        margin-bottom: 10px;
    }
    .wpmet-ann-thumb {
        width: 75px;
        padding-right: 7px;
        box-sizing: border-box;
        align-self: flex-start;
        padding-top: 5px;
    }
    .wpmet-ann-thumb img {
        width: 100%;
        display: block;
        min-height: 34px;
    }
    .wpmet-ann-desc.with-image {
        width: calc(100% - 75px);
        font-weight: 400;
        line-height: 1.5;
        font-size: 13px;
    }
    .wpmet-ann-desc a {
        font-weight: 500;
        color: #0073aa;
        text-decoration: none;
        padding-bottom: 5px;
        display: inline-block;
    }
    .wpmet-ann:last-child {
        margin-bottom: 0;
    }
    .wpmet-ann-desc span {
    display: block;
    }
    .wpmet-bullet-wall {
        width: 6px;
        height: 6px;
        border-radius: 50%;
        background-color: black;
        display: inline-block;
        margin: 0 5px;
    }
    .wpmet-dashboard-widget-block {
        width: 100%;
    }
    .wpmet-dashboard-widget-block .wpmet-title-bar a{
        color: #23282d;
        font-weight: 400;
        font-size: 12px;
    }
    .wpmet-dashboard-widget-block .wpmet-title-bar {
        display: table;
        width: 100%;
        -webkit-box-shadow: 0 5px 8px rgba(0, 0, 0, 0.05);
        box-shadow: 0 5px 8px rgba(0, 0, 0, 0.05);
        margin: 0 -12px 8px;
        padding: 0 12px 12px;
    }
    .wpmet-dashboard-widget-block .wpmet-footer-bar {
        border-top: 1px solid #eee;
        padding-top: 1rem;
    }
    .wpmet-dashboard-widget-block .wpmet-footer-bar a {
        padding: 0 5px;
    }
    .wpmet-dashboard-widget-block a {
        text-decoration: none;
        font-size: 14px;
        color: #007cba;
        font-weight: 600;
    }
    .wpmet-ann .wpmet-banner {
        width: 100%;
        height: 50px;
    }
    .wpmet-dashboard-widget-block .dashicons {
        vertical-align: middle;
        font-size: 17px;
    }
</style>

<div class="wpmet-dashboard-widget-block">
    <div class="wpmet-title-bar">
        <?php
        foreach ($this->plugin_link as $k => $link) {
            echo '<a href="' . $link[1] . '">' . $link[0] . '</a>';
            if (isset($this->plugin_link[$k + 1])) {
                echo '<div class="wpmet-bullet-wall"></div>';
            }
        }
        ?>
    </div>
</div>

<?php 
foreach ($this->announcements as $announcements) {
    if($announcements['type'] === 'news' || $announcements['type'] === '') :
        ?>
        <div class="wpmet-ann <?php echo ((isset($announcements['announcements_image']) && $announcements['announcements_image'] != '') ? 'with-image' : ''); ?>">
            <?php if(isset($announcements['announcements_image']) && $announcements['announcements_image'] != ''): ?>
                <div class="wpmet-ann-thumb">
                    <img src="<?php echo esc_url($announcements['announcements_image']); ?>" />
                </div>
            <?php endif; ?>

            <div  class="wpmet-ann-desc">

                <a  href="<?php echo esc_url($announcements['announcements_link']) ?>">
                    <?php echo esc_html($announcements['title']); ?>    
                </a>

                <?php if(isset($announcements['description']) && $announcements['description'] != ''): ?>
                    <span><?php echo esc_html($announcements['description']); ?>  </span>
                <?php endif; ?>
                
            </div>
        </div>
    <?php
    elseif($announcements['type'] === 'banner') :
    ?>
        <div class="wpmet-ann">
            <img class="wpmet-banner" src="<?php echo isset($announcements['announcements_image']) && $announcements['announcements_image'] != '' ? $announcements['announcements_image'] : '#'; ?>" />
        </div>
        <?php
    endif;
}
?>

<div class="wpmet-dashboard-widget-block">
    <div class="wpmet-footer-bar">
        <a href="https://help.wpmet.com/" target="_blank">
            <?php echo esc_html__('Need Help?', $this->text_domain); ?> 
            <span aria-hidden="true" class="dashicons dashicons-external"></span>
        </a>
        <a href="https://wpmet.com/blog/" target="_blank">
        <?php echo esc_html__('Blog', $this->text_domain) ;?> 
            <span aria-hidden="true" class="dashicons dashicons-external"></span>
        </a>
        <a href="https://go.wpmet.com/facebook-group" target="_blank" style="color: #27ae60;">
            <?php echo esc_html__('Facebook Community', $this->text_domain); ?> 
            <span aria-hidden="true" class="dashicons dashicons-external"></span>
        </a>
    </div>
</div>